import {createApiMethod} from '../helpers/api';

module.exports = createApiMethod({
    name: 'transport',
    params: {
        language: {
            type: 'String',
            required: true,
        },
        transportType: {
            type: 'String',
            required: true,
        },
        countryCode: {
            type: 'String',
            required: true,
        },
    },

    buildPath: ({language, transportType}) => {
        return `/${language}/transport/${transportType}/`;
    },
    buildOperationName: () => '/:language/transport/:transportType/',

    buildQuery: ({countryCode}) => ({
        country: countryCode,
    }),
});
