import {createApiMethod} from '../helpers/api';

module.exports = createApiMethod({
    name: 'transportPopularDirections',
    params: {
        language: {
            type: 'String',
            required: true,
        },
        slug: {
            type: 'String',
            required: true,
        },
        transportType: {
            type: 'String',
            required: true,
        },
        limit: {
            type: 'Number',
            defaultValue: 20,
        },
    },
    defaultResponse: {
        toSettlement: [],
        fromSettlement: [],
    },

    buildPath: ({language, slug}) => {
        return `/${language}/settlement/${slug}/transport-popular-directions/`;
    },
    buildOperationName: () =>
        '/:language/settlement/:slug/transport-popular-directions/',
    buildQuery: ({limit, transportType}) => ({
        t_type: transportType,
        limit,
    }),
});
