import Req from '../../../common/interfaces/router/Req';
import ICookie from '../../../common/interfaces/cookies/ICookie';
import IStateFlags from '../../../common/interfaces/state/flags/IStateFlags';
import {ECommonHeaders} from '../../../common/interfaces/api/ECommonHeaders';

export const getICookie = (cookies: ICookie): string => cookies.i;

export const convertUAASExperimentsToString = (flags: IStateFlags): string =>
    JSON.stringify(flags);

export const getCommonHeaders = ({
    request,
    flags,
}: {
    request: Req;
    flags: IStateFlags;
}): Record<ECommonHeaders, string> => {
    const {cookies} = request;
    const iCookie = getICookie(cookies);
    const uaasExperiments = convertUAASExperimentsToString(flags);

    return {
        [ECommonHeaders.X_YA_ICOOKIE]: iCookie,
        [ECommonHeaders.X_YA_UAAS_EXPERIMENTS]: uaasExperiments,
    };
};
