import IApiCommonErrors from '../../../common/interfaces/api/IApiCommonErrors';

export default function requestIsFailed(body: IApiCommonErrors): boolean {
    if (!body.errors) {
        return false;
    }

    if (typeof body.errors === 'string') {
        return body.errors.length > 0;
    }

    if (Array.isArray(body.errors)) {
        return body.errors?.length > 0;
    }

    return Object.values(body.errors).length > 0;
}
