/*
 * Данный конфиг является базовым. Остальные конфиги могут дополнять и перекрывать
 * элементы из него.
 */

import os from 'os';
import path from 'path';
import csp from '@yandex-int/csp-presets-pack';

import ALTERNATE_LANGUAGE_DOMAINS from '../../common/lib/url/alternateLanguageDomains';

import packagejson from '../../package.json';

import getCountCpu from '../helpers/getCountCpu';

const debVersion = process.env.DEB_VERSION || packagejson.debversion;
const isDeploy = Boolean(process.env.DEPLOY_POD_PERSISTENT_FQDN);

module.exports = {
    useQloudLogging: !isDeploy,
    useDeployLogging: isDeploy,

    bunker: {
        protocol: 'http:',
        timeout: 5000,
        hostname: 'bunker-api.yandex.net',
    },

    tvm: {
        destinations: ['blackbox'],
        serverUrl: isDeploy
            ? process.env.DEPLOY_TVM_TOOL_URL
            : 'http://localhost:1',
        token: isDeploy
            ? process.env.TVMTOOL_LOCAL_AUTHTOKEN
            : process.env.QLOUD_TVM_TOKEN,
    },

    blackbox: {
        api: 'blackbox.yandex.net',
        family: process.env.RASP_CONTAINER_RUN_LOCALLY ? 4 : 6,
        aliases: 'all',
        getServiceTicket: req => {
            // Тикеты доступны в req.tvm.tickets и разложены по destinations
            if (req.tvm && req.tvm.tickets && req.tvm.tickets.blackbox) {
                return req.tvm.tickets.blackbox.ticket;
            }
        },
        attributes: {
            login: '1008',
            lang: '34',
        },
    },

    jaeger: {
        serviceName: 'rasp.morda-front',
        host: 'https://jaeger.yt.yandex-team.ru/travel/search',
    },

    startrek: {
        options: {
            protocol: 'https:',
            host: 'st-api.yandex-team.ru',
        },
        key: process.env.STARTREK_AUTH_KEY,
        queue: 'RASPFRONT',
        components: [72719],
        keyTravel: process.env.STARTREK_TRAVEL_AUTH_KEY,
        queueTravel: 'TRAVELFRONT',
    },

    distribution: {
        options: {
            protocol: 'https:',
            host: 'registry.yandex.net',
        },
        token: process.env.DOCKER_REGISTRY_TOKEN,
    },

    yp: {
        options: {
            protocol: 'https:',
            host: 'xdc.yp.yandex.net',
            rejectUnauthorized: false,
            port: 8443,
        },
        token: process.env.DCTL_YP_TOKEN,
    },

    langdetect: {
        availableLanguages: {
            ru: ['ru'],
            ua: ['ru', 'uk'],
            by: ['ru'],
            kz: ['ru'],
            uz: ['ru'],
        },
        langDetectData: '/usr/share/yandex/lang_detect_data.txt',
        exposeLangdetector: true,
        defaultLanguage: 'ru',
    },

    altLangDomains: ALTERNATE_LANGUAGE_DOMAINS,

    nationalredirect: {
        app: {
            domains: ['ru', 'by', 'kz', 'uz'],
        },
    },

    nationalredirectTouch: {
        app: {
            domains: ['ru', 'by', 'kz', 'uz'],
        },
    },

    uatraits: {
        browser: '/usr/share/uatraits/browser.xml',
        profiles: '/usr/share/uatraits/profiles.xml',
        module: '/usr/lib/node_modules/uatraits',
    },

    geobase: {
        geobaseData: '/var/cache/geobase/geodata6.bin',
        version: 6,
    },

    httpGeobase: {
        server: 'http://geobase.qloud.yandex.ru',
    },

    mail: {
        host: 'send-mail.corba.yandex.net:80',
    },

    static: {
        host: `https://yastat.net/s3/rasp/s/morda-front/${debVersion}`,
        hostWithoutVersion: 'https://yastat.net/s3/rasp/s/morda-front/_',
    },

    server: {
        socket: '/tmp/application.sock',
        port: process.env.PORT,
        hostname: os.hostname(),
    },

    app: {
        id: packagejson.name,
        version: debVersion,
    },

    cluster: {
        workersCount: getCountCpu(),
    },

    api: {
        options: {
            protocol: process.env.BACKEND_PROTOCOL || 'https:',
            timeout: 10000,
            rejectUnauthorized: false,
            hostname: process.env.BACKEND_HOST,
        },
        purchaseOptions: {
            protocol: process.env.BACKEND_PURCHASE_PROTOCOL || 'https:',
            timeout: 20000,
            rejectUnauthorized: false,
            hostname: process.env.BACKEND_PURCHASE_HOST,
        },
        pathfinderOptions: {
            protocol: process.env.BACKEND_PATHFINDER_PROTOCOL || 'https:',
            timeout: 10000,
            rejectUnauthorized: false,
            hostname: process.env.BACKEND_PATHFINDER_HOST,
        },
    },

    errorCounter: {
        project: 'travel',
        service: 'rasp.frontend',
        uncaughtException: true,
        unhandledRejection: true,
        traceUnhandledRejection: true,
        debug: false,
        throttleSend: 500,
    },

    blablacar: {
        requestOptions: {
            protocol: 'http:',
            timeout: 10000,
            rejectUnauthorized: false,
            hostname:
                process.env.BACKEND_BLABLACAR_HOST ||
                'production.blablacar.rasp.yandex.net',
        },
    },

    defaultTimezone: 'Europe/Moscow',

    tanker: {
        prj: 'rasp-morda-front',
        host: 'tanker-api.yandex-team.ru',
        port: 443,
        rev: 'master',
        token: process.env.TANKER_API_TOKEN || '', // Для запроса на чтение не нужен токен
        langs: ['ru', 'uk'],
    },

    suggests: {
        url: process.env.SUGGESTS_URL || '//suggests.rasp.yandex.net/',
    },

    csp: {
        policies: {
            [csp.DEFAULT]: [csp.NONE],
            [csp.SCRIPT]: [
                csp.SELF,
                csp.EVAL,
                csp.NONCE,
                csp.INLINE,
                'yastatic.net',
                'yastat.net',
                'yandex.ru',
                'mail.yandex.ru', // mail
                'api-maps.yandex.ru',
                '*.maps.yandex.net', // maps
                'mc.yandex.ru',
                'an.yandex.ru', // banners and metrika
                'social.yandex.net',
                'social.yandex.%tld%',
                'export.yandex.ru',
                'pass.yandex.ru', // passport
                'suggests3.rasp.yandex.net', // suggests
                'suggests.rasp.yandex.net',
                'webvisor.com',
                'browser-updater.yandex.net', // updater for old browsers
            ],
            [csp.STYLE]: [
                csp.SELF,
                csp.INLINE,
                'yastatic.net',
                'yastat.net',
                'mc.yandex.ru',
                'webvisor.com',
            ],
            [csp.FONT]: [csp.SELF, csp.DATA, 'yastatic.net', 'yastat.net'],
            [csp.IMG]: [
                csp.SELF,
                csp.DATA,
                'yandex.ru',
                'avatars.yandex.net',
                'mc.yandex.ru',
                'yastatic.net',
                'yastat.net',
                'avatars.mds.yandex.net',
                'yapic.yandex.net',
                'an.yandex.ru',
                'favicon.yandex.net',
                'avatars-fast.yandex.net',
                'bs-meta.yandex.ru',
                'adtune.yandex.ru',
                'www.tns-counter.ru',
                'ar.tns-counter.ru',
                'awaps.yandex.ru',
                'awaps.yandex.net',
                'storage.mds.yandex.net',
                '*.weborama.fr', // Видео-реклама в Direct
                'static.rasp.yandex.net',
                'yastat.net',
                'api-maps.yandex.ru',
                '*.maps.yandex.net', // Карты
                'mc.admetrica.ru',
                'ads.adfox.ru',
                'matchid.adfox.yandex.ru', // реклама через adFox
            ],
            [csp.FRAME]: [
                csp.SELF,
                'st.yandexadexchange.net',
                'yandexadexchange.net',
                'awaps.yandex.ru',
                'awaps.yandex.net',
                'yastatic.net',
                'mc.yandex.ru',
                'dl.metabar.ru', // AVIA ticket
                '*.yandex.ru',
                '*.yandex.net',
                'yandex.st',
            ],
            // Начиная с 2017 DEPRECATED в CSP v2, основной заголовок frame-src, TODO: Удалить child-src
            [csp.CHILD]: [
                csp.SELF,
                'st.yandexadexchange.net',
                'yandexadexchange.net',
                'awaps.yandex.ru',
                'awaps.yandex.net',
                'mc.yandex.ru',
            ],
            [csp.CONNECT]: [
                csp.SELF,
                'mc.yandex.ru',
                'yandex.ru',
                'suggests.rasp.yandex.net',
                'suggests3.rasp.yandex.net',
                'an.yandex.ru',
                'sovetnik.market.yandex.ru/',
                'matchid.adfox.yandex.ru',
            ],
            [csp.MEDIA]: [
                'strm.yandex.ru', // Видео-реклама в Direct
            ],
        },
        presets: [csp.adsdk()],
        useDefaultReportUri: true,
        serviceName: 'rasp-front',
    },

    logPaths: {
        search: '/var/log/app/yt/search.log',
        yBus: '/var/log/app/yt/yBus.log',
    },

    /**
     * Достаточно добавить эксперимент только в данный файл - тогда он прорастет во все окружения.
     * Можно переопределить эксперимент в конфиге для конкретного окружения (например в ./development.js).
     *
     * Пример конфигурации экспериментов:
     *
     * Важно: нельзя просто так взять и изменить процент распределения у эксперимента!
     * Потому как новое распределение значений кук будет работать только для новых пользователей.
     * Так что, если нужно изменить процент распределения, необходимо завести новый эксперимент (с
     * новым названием).
     * Разумеется речь идет только про прод и при разработке позволяется менять проценты эксперимента
     * сколько угодно раз, но не увлекайтесь, потому что от этого, говорят, волосы на ладошках растут.
     *
     * experiments: {
     *     __booleanExperiment: {
     *        type: Boolean,
     *        percentage: 10, // для 10% пользователей значение __booleanExperiment будет выставлено в true,
     *                       // у остальных – false
     *        defaultValue: true, // по умолчанию false для Boolean
     *        denied: true // означает, что будет использовано значение defaultValue и кука
     *                     // не будет выставляться пользователям. По умолчанию имеет значение false
     *    },
     *
     *    __numberExperiment: {
     *        type: Number,
     *        values: [
     *            {
     *                value: 20,
     *                percentage: 15 // для 15% пользователей значение __numberExperiment будет выставлено в 20
     *            },
     *            {
     *                value: 100,
     *                percentage: 15 // для других 15% значение __numberExperiment будет выставлено в 100
     *            }
     *        ],
     *        defaultValue: 10 // для остальных 70% выставляем 10
     *    },
     *
     *    __stringExperiment: {
     *        ...
     *        dependencies: { // зависимый эксперимент выставляется только тем пользователям,
     *                     // которые попали в родительские эксперименты, у остальных будет undefined
     *
     *            __booleanExperiment: [true],  // __stringExperiment будет выставляться только тем,
     *                                          // у кого __booleanExperiment равен true
     *            __numberExperiment: [10, 20]  // и при этом numberExperiment равен 10 или 20
     *        }
     *        dynamic: true // Значение зависит от внешнего мира, при запросах его надо обновлять
     *                      // т.е. кука будет высчитываться и перезаписываться у пользователя
     *                      // при каждом запросе
     *    }
     *
     *    __funcExperiment: function(req){       // эксперимент в виде функции, возвращающей промис
     *        return new Promise((resolve) => {
     *          setTimeout(() => resolve({
     *              type: Boolean,
     *              percentage: 10
     *           }), 10);
     *        });
     *    }
     */
    experiments: {
        __ufsTesting: {
            type: Boolean,
            denied: true,
        },
        __ridesharingPartnersDisabled: {
            type: Boolean,
            defaultValue: process.env.RIDESHARING_PARTNERS_DISABLED === 'true',
            denied: true,
        },
        __webvisor: {
            type: Boolean,
            percentage: 15,
        },
        __yabusOfflineLabel: {
            type: Number,
            values: [
                {
                    value: 1,
                    percentage: 30,
                },
                {
                    value: 2,
                    percentage: 30,
                },
            ],
            defaultValue: 0,
        },
        // Эксперимент с показом требований к местам вместо схемы
        __filledSchemaRequirements: {
            type: Boolean,
            denied: true,
        },
        // Эксперимент с комиссией яндекса
        // Такое название, чтобы не привлекать любопытных людей, которые смотрят в куки
        __experiment: {
            type: Boolean,
            percentage: 50,
        },
        __everlastingHomeTouchExperiment: {
            type: Boolean,
            percentage: 50,
        },
        __everlastingSearchTouchExperiment: {
            type: Boolean,
            percentage: 50,
        },
        __everlastingThreadTouchExperiment: {
            type: Boolean,
            percentage: 50,
        },
        __everlastingStationTouchExperiment: {
            type: Boolean,
            percentage: 50,
        },
        __mirCashbackBanner: {
            type: Boolean,
            defaultValue: process.env.MIR_CASHBACK_BANNER === 'on',
            denied: true,
        },
        // За флагом предыдущее поведение: ссылки с страницы поиска на страницы нитки не канонические
        __notCanonicalThreadUid: {
            type: Boolean,
            percentage: 0,
        },
        // Позволяет видеть в консоли все флаги, которые приходят (из кук + из abt)
        __showFlagsInConsole: {
            type: Boolean,
            percentage: 0,
            defaultValue: false,
        },
    },

    mockRealIpX: '37.140.187.104', // мок на ip из сети Яндекса
    pathToVersionFile: path.join(__dirname, '../controllers/versionData.txt'),
};
