/*
 * Данный конфиг используется как для разработческих машин, так и для запуска
 * браузерных тестов в тимсити
 */
import path from 'path';
import csp from '@yandex-int/csp-presets-pack';

import packagejson from '../../package.json';
import defaultConfig from './default';

const root = path.join(__dirname, '../..');
const user = process.env.SUDO_USER || process.env.USER;
const cspDefault = defaultConfig.csp.policies;

const HTTP_SERVICES_TIMEOUT = 300;

module.exports = {
    useQloudLogging: false,
    useDeployLogging: false,

    blablacar: {
        requestOptions: {
            protocol: 'http:',
            timeout: 10000,
            rejectUnauthorized: false,
            hostname:
                process.env.BACKEND_BLABLACAR_HOST ||
                'testing.blablacar.rasp.yandex.net',
        },
    },

    bunker: {
        hostname: 'bunker-api-dot.yandex.net',
    },

    static: {
        host: '',
        hostWithoutVersion: '/_',
    },

    httpGeobase: {
        server: 'http://geobase-test.qloud.yandex.ru',
        clientOptions: {
            timeout: HTTP_SERVICES_TIMEOUT,
        },
    },

    server: {
        port: process.env.PORT,
        socket: path.join('/tmp', `${packagejson.name}.${user}.sock`),
    },

    app: {
        version: 'dev',
    },

    blackbox: {
        api: 'pass-test.yandex.ru',
    },

    jaeger: {
        host: 'http://localhost:16686/search',
    },

    startrek: {
        options: {
            host: 'st-api.test.yandex-team.ru',
        },
        components: [44959],
    },

    mail: {
        host: 'zealot.yandex.ru:32500',
    },

    cluster: {
        workersCount: 1,
    },

    api: {
        useFixtures: true,
        options: {
            timeout: 30000,
            hostname:
                process.env.BACKEND_HOST ||
                'testing.morda-backend.rasp.yandex.net',
            protocol: process.env.BACKEND_PROTOCOL || 'http:',
        },
        purchaseOptions: {
            timeout: 30000,
            hostname:
                process.env.BACKEND_PURCHASE_HOST ||
                'testing.train-api.rasp.internal.yandex.net',
        },
        pathfinderOptions: {
            timeout: 30000,
            hostname:
                process.env.BACKEND_PATHFINDER_HOST ||
                'testing.pathfinder-proxy.rasp.common.yandex.net',
        },
    },

    suggests: {
        url:
            process.env.SUGGESTS_URL ||
            'https://testing.suggests.rasp.common.yandex.net/',
    },

    csp: {
        policies: {
            [csp.SCRIPT]: [].concat(cspDefault[csp.SCRIPT], [
                'suggests.tst.rasp.yandex.ru',
                'testing.suggests.rasp.common.yandex.net',
            ]),
            [csp.IMG]: [].concat(cspDefault[csp.IMG], [
                'work.admin-test.rasp.yandex.ru',
                'work.admin-test.rasp.yandex-team.ru',
                'rasp-test-media-bucket.s3.yandex.net',
                'yastat.net', // Потому что локальный сервер на http
            ]),
            [csp.CONNECT]: [].concat(cspDefault[csp.CONNECT], [
                'suggests.tst.rasp.yandex.ru',
                'testing.suggests.rasp.common.yandex.net',
            ]),
        },
        reportOnly: true,
    },

    logPaths: {
        search: path.join(root, 'log', 'yt', 'search.log'),
        searchTransfers: path.join(root, 'log', 'yt', 'search_transfers.log'),
        yBus: path.join(root, 'log', 'yt', 'yBus.log'),
    },

    experiments: {
        __ufsTesting: {
            type: Boolean,
            denied: true,
        },
        __webvisor: {
            // отключаем вебвизор для разработки
            type: Boolean,
            denied: true,
        },
        __testPlaces: {
            // данный эксперимент используется в браузерном тесте 365
            // там просиходит перезапись его значения через url
            type: Boolean,
            denied: true,
        },
    },
};
