import csp from '@yandex-int/csp-presets-pack';

import defaultConfig from './default';

const cspDefault = defaultConfig.csp.policies;

module.exports = {
    blablacar: {
        requestOptions: {
            protocol: 'http:',
            timeout: 10000,
            rejectUnauthorized: false,
            hostname:
                process.env.BACKEND_BLABLACAR_HOST ||
                'testing.blablacar.rasp.yandex.net',
        },
    },

    bunker: {
        api: 'http://bunker-api-dot.yandex.net/v1',
    },

    startrek: {
        options: {
            host: 'st-api.test.yandex-team.ru',
        },
    },

    blackbox: {
        api: 'pass-stress-na1.sezam.yandex.net',
    },

    mail: {
        host: 'zealot.yandex.ru:32500',
    },

    suggests: {
        url: process.env.SUGGESTS_URL || null,
    },

    csp: {
        policies: {
            [csp.SCRIPT]: [].concat(cspDefault[csp.SCRIPT], [
                'suggests.load.rasp.yandex.net',
            ]),
        },
    },
};
