const url = require('url');

const helper = require('../helpers/stationRouteSearchHelper');

exports.stationRouteSearch = function (req, res) {
    const queryText = req.query.query || '';
    const id = req.query.id || '';
    const queryParams = {};

    if (req.query.lang) {
        queryParams.lang = req.query.lang;
    }

    const isRoute = !id && helper.isRouteNumber(queryText);

    if (isRoute) {
        res.redirect(
            url.format({
                pathname: '/threads/',
                query: Object.assign(
                    {
                        number: queryText,
                    },
                    queryParams,
                ),
            }),
        );
    } else {
        res.redirect(
            url.format({
                pathname: '/station_search/',
                query: Object.assign(
                    {
                        cityFrom: queryText,
                        cityFromId: id,
                    },
                    queryParams,
                ),
            }),
        );
    }
};
