import fsExtra from 'fs-extra';
import yaConfig from '@yandex-int/yandex-config';
import {Response, NextFunction} from 'express';
import got from 'got';

import IExpressRequest from '../../common/interfaces/IExpressRequest';

import getStaffLogin from '../helpers/getStaffLogin';

const config = yaConfig();

export default async function version(
    req: IExpressRequest,
    res: Response,
    next: NextFunction,
): Promise<void> {
    try {
        if (!getStaffLogin(req)) {
            return next();
        }

        const frontendVersionData = await fsExtra.readFile(
            config.pathToVersionFile,
            {encoding: 'utf8'},
        );
        const {body: mordaBackendVersion} = await got({
            ...config.api.options,
            path: '/version',
        });

        const mordaBackendHost = `${config.api.options.protocol}${config.api.options.hostname}`;
        const trainApiHost = `${config.api.purchaseOptions.protocol}${config.api.purchaseOptions.hostname}`;
        const pathfinderHost = `${config.api.pathfinderOptions.protocol}${config.api.pathfinderOptions.hostname}`;

        const result =
            `mordaBackend: ${mordaBackendHost} (version: ${mordaBackendVersion.replace(
                /\n/g,
                ' ',
            )})` +
            `\ntrainApiHost: ${trainApiHost}` +
            `\npathfinderHost: ${pathfinderHost}` +
            `\n\n${frontendVersionData}`;

        res.set('Content-Type', 'text/plain');
        res.send(result);
    } catch (error) {
        next(error);
    }
}
