import url from 'url';
import qs from 'qs';

import {YBUS} from '../../../common/lib/segments/tariffSources';

import ISearchContext from '../../../common/interfaces/state/search/ISearchContext';

import {stationIsCity} from '../../../common/lib/segments/stations';
import getTravelDomain from '../../../common/lib/url/getTravelDomain';
import makeExternalUrl from '../../../common/lib/url/makeExternalUrl';

export default function patchBusTariffs(
    segments: any[],
    context: ISearchContext,
): any[] {
    return segments.map(segment => {
        if (segment.tariffs) {
            const {classes} = segment.tariffs || {};

            Object.keys(classes).forEach(key => {
                const {orderUrl} = classes[key];

                if (orderUrl) {
                    const {query} = url.parse(orderUrl);
                    const parsedQuery = qs.parse(query || '');

                    classes[key].parsedUrl = {
                        pathname: `${getTravelDomain({
                            isProduction: true,
                        })}/buses/order/`,
                        query: {
                            ...parsedQuery,
                            rideId: segment.yBusId,
                            from: context.from.slug,
                            to: context.to.slug,
                            when: context.when.date,
                            placesCount: '1',
                        },
                    };
                    classes[key].orderUrl = makeExternalUrl(
                        classes[key].parsedUrl.pathname,
                        classes[key].parsedUrl.query,
                    );
                }
            });
        }

        segment.source = YBUS;
        segment.useCityInsteadStationTo = stationIsCity(segment.stationTo);
        segment.useCityInsteadStationFrom = stationIsCity(segment.stationFrom);

        return segment;
    });
}
