interface IGetInformerMetrikaParams {
    counterCode: number;
    nonce: string; // Атрибут nonce - уникальное для каждого запроса значение подписи для подписывания инлайн-кода чтобы соблюдать Content Security Policy (https://wiki.yandex-team.ru/product-security/csp/)
}

export default function getInformerMetrika({
    counterCode,
    nonce,
}: IGetInformerMetrikaParams): string {
    return `
    <!-- Yandex.Metrika counter -->
    <script type="text/javascript" nonce="${nonce}" >
        (function(m,e,t,r,i,k,a){m[i]=m[i]||function(){(m[i].a=m[i].a||[]).push(arguments)};
        m[i].l=1*new Date();k=e.createElement(t),a=e.getElementsByTagName(t)[0],k.async=1,k.src=r,a.parentNode.insertBefore(k,a)})
        (window, document, "script", "https://mc.yandex.ru/metrika/tag.js", "ym");

        ym(${counterCode}, "init", {
            clickmap:true,
            trackLinks:true
        });
    </script>
    <noscript><div><img src="https://mc.yandex.ru/watch/${counterCode}" style="position:absolute; left:-9999px;" alt="" /></div></noscript>
    <!-- /Yandex.Metrika counter -->
    `;
}
