import environment from '@yandex-int/yandex-environment';

import IStateFlags from '../../../common/interfaces/state/flags/IStateFlags';
import IExpressRequest from '../../../common/interfaces/IExpressRequest';
import Environment from '../../../common/interfaces/Environment';

import {getInitEventId, getCounterCode} from '../../../common/lib/yaMetrika';

interface IMetrikaParams {
    nonce: string;
    isTouch: boolean;
    flags: IStateFlags;
    abtInfo: IExpressRequest['abtInfo'];
}

export default function metrika({
    nonce,
    isTouch,
    flags,
    abtInfo,
}: IMetrikaParams): string {
    const counterCode = getCounterCode(isTouch);

    return `
    <script type="text/javascript" nonce="${nonce}">
        (function (d, w, c) {
            (w[c] = w[c] || []).push(function() {
                try {
                    w.yaCounter = new Ya.Metrika2({
                        id:${counterCode},
                        clickmap:true,
                        trackLinks:true,
                        accurateTrackBounce:true,
                        webvisor:${flags.__webvisor},
                        triggerEvent:true,
                        ut:"noindex",
                        tns: {
                            account: 'yandex_ru',
                            tmsec: 'yandex_rasp'
                        }
                        ${
                            environment === Environment.production
                                ? `,experiments: '${abtInfo?.experiments}'`
                                : ''
                        }
                    });
                } catch(e) { }
            });

            var n = d.getElementsByTagName("script")[0],
                s = d.createElement("script"),
                f = function () { n.parentNode.insertBefore(s, n); };
            s.type = "text/javascript";
            s.async = true;
            s.src = "https://mc.yandex.ru/metrika/tag.js";

            if (w.opera == "[object Opera]") {
                d.addEventListener("DOMContentLoaded", f, false);
            } else { f(); }
        })(document, window, "yandex_metrika_callbacks2");

        document.addEventListener('${getInitEventId(isTouch)}', function(e) {
            if (typeof window.yaCounterQueue !== 'undefined' && window.yaCounter) {
                for (var i in window.yaCounterQueue) {
                    var goalObject = window.yaCounterQueue[i];
                    window.yaCounter.reachGoal.apply(window.yaCounter, [goalObject.target].concat(goalObject.props));
                }
                delete(window.yaCounterQueue);
            }
        });
    </script>
    <noscript><div><img src="https://mc.yandex.ru/watch/${counterCode}?ut=noindex" style="position:absolute; left:-9999px;" alt="" /></div></noscript>
    `;
}
