import {EDeployLevel, IDeployMessageFormat} from './types';
import levelNameMap from './levelNameMap';

interface IFormatDeployMessageParams {
    levelStr: EDeployLevel;
    message: string;
    stackTrace?: string;

    [other: string]: unknown;
}

export default function formatDeployLogMessage({
    levelStr,
    message,
    stackTrace,
    ...other
}: IFormatDeployMessageParams): IDeployMessageFormat {
    return {
        '@timestamp': new Date().toISOString(),
        message,
        stackTrace,
        levelStr,
        level: levelNameMap[levelStr],
        ...other,
    };
}
