import {TLoggerLevel} from '../../../common/interfaces/ILogger';
import {EDeployLevel} from './types';

export default function prepareDeployLoggerLevel(
    level: TLoggerLevel,
): EDeployLevel {
    switch (level) {
        case 'info':
            return EDeployLevel.INFO;
        case 'debug':
            return EDeployLevel.DEBUG;
        case 'warning':
            return EDeployLevel.WARNING;
        case 'error':
            return EDeployLevel.ERROR;
        case 'fatal':
            return EDeployLevel.ERROR;
    }
}
