export enum EDeployLevel {
    TRACE = 'TRACE',
    DEBUG = 'DEBUG',
    INFO = 'INFO',
    WARNING = 'WARNING',
    ERROR = 'ERROR',
}

/**
 * @link https://deploy.yandex-team.ru/docs/concepts/pod/sidecars/logs/logs#3.2.-format-soobshenij
 */
export interface IDeployMessageFormat {
    /**
     * @example 2015-08-21T12:27:16.818+03:00
     */
    '@timestamp': string;
    message: string;
    /**
     * Прочий контекст, может быть вложенным
     */
    '@fields'?: Record<string, unknown>;
    stackTrace?: string;
    loggerName?: string;
    threadName?: string;
    levelStr: EDeployLevel;
    level: number;

    /**
     * Если в сообщении есть поля, не укладывающиеся в приведенную схему,
     * они сохраняются в поле context (если в поле context, уже есть поле с аналогичным именем, то его значение будет перезатерто).
     */
    [other: string]: unknown;
}
