import {Response} from 'got';
import yaConfig from '@yandex-int/yandex-config';

import HttpMethod from '../../../common/interfaces/HttpMethod';

import timedGot from '../timedGot';

const distributionConfig = yaConfig().distribution;

interface IApiRequest {
    path: string; // Метод API

    method?: HttpMethod;
    body?: Record<string, any>;
    retries?: number;
    json?: boolean;
    headers?: Record<string, string>;
}

export default function apiRequest({
    path,

    method = HttpMethod.get,
    body,
    retries = 0,
    json = true,
    headers = {},
}: IApiRequest): Promise<Response<any>> {
    // any потому, что тайпинги got написаны неправильно - возможна еще и передача всех параметров первым аргументом, что и используется в timedGot

    return timedGot({
        ...distributionConfig.options,
        retries,
        method,
        path,
        json,
        body,
        headers: {
            ...headers,
            Authorization: `OAuth ${distributionConfig.token}`,
        },
    });
}
