import apiRequest from './apiRequest';

export async function getManifest(repo: string, tag: string): Promise<string> {
    const {body: manifest} = await apiRequest({
        path: `/v2/${repo}/manifests/${tag}`,
        json: false,
        headers: {
            Accept: 'application/vnd.docker.distribution.manifest.v2+json',
        },
    });

    return manifest;
}
