import {getHostForFavicons} from '../../webpack/staticUtils';

const faviconsHost = getHostForFavicons();

function baseLink(url) {
    return `${faviconsHost}/${url}`;
}

export const FAVICONS_LIST = {
    favicon: baseLink('favicon.ico'),

    favicons: {
        16: baseLink('favicon-16x16.png'),
        32: baseLink('favicon-32x32.png'),
        96: baseLink('favicon-96x96.png'),
    },

    apple: {
        57: baseLink('apple-touch-icon-57x57.png'),
        60: baseLink('apple-touch-icon-60x60.png'),
        72: baseLink('apple-touch-icon-72x72.png'),
        67: baseLink('apple-touch-icon-76x76.png'),
        114: baseLink('apple-touch-icon-114x114.png'),
        120: baseLink('apple-touch-icon-120x120.png'),
        144: baseLink('apple-touch-icon-144x144.png'),
        152: baseLink('apple-touch-icon-152x152.png'),
    },

    maskIcon: baseLink('mask-icon.svg'),
    ogImage: baseLink('og-image.png'),
    browserConfig: baseLink('browserConfig.xml'),
};

export function generateMSApplicationConfig() {
    return `<?xml version="1.0" encoding="utf-8"?>
<browserconfig>
    <msapplication>
        <tile>
            <square70x70logo src="${baseLink('tile-small.png')}"/>
            <square150x150logo src="${baseLink('tile-medium.png')}"/>
            <wide310x150logo src="${baseLink('tile-wide.png')}"/>
            <square310x310logo src="${baseLink('tile-large.png')}"/>
            <TileColor>#e6e4e1</TileColor>
        </tile>
    </msapplication>
</browserconfig>`;
}

function makeFavicon(size) {
    return {
        rel: 'icon',
        type: 'image/png',
        sizes: `${size}x${size}`,
        href: FAVICONS_LIST.favicons[size],
    };
}

function makeAppleTouchIcon(size) {
    return {
        rel: 'apple-touch-icon',
        sizes: `${size}x${size}`,
        href: FAVICONS_LIST.apple[size],
    };
}

export function getFaviconsTags() {
    return {
        link: [
            {
                rel: 'shortcut icon',
                type: 'image/x-icon',
                href: FAVICONS_LIST.favicon,
            },
            {
                rel: 'mask-icon',
                sizes: 'any',
                href: FAVICONS_LIST.maskIcon,
                color: '#f00',
            },
            ...Object.keys(FAVICONS_LIST.favicons).map(makeFavicon),
            ...Object.keys(FAVICONS_LIST.apple).map(makeAppleTouchIcon),
        ],
        meta: [
            {property: 'og:image', content: FAVICONS_LIST.ogImage},
            {
                name: 'msapplication-config',
                content: FAVICONS_LIST.browserConfig,
            },
            {
                'http-equiv': 'X-UA-Compatible',
                content: 'IE=edge',
            },
        ],
    };
}
