import fs from 'fs';

export const writeFilePromise = (filePath, fileContent) => resolveWith =>
    new Promise((resolve, reject) => {
        fs.writeFile(filePath, fileContent, err =>
            err ? reject(err) : resolve(resolveWith),
        );
    });

export const mkdirPromise = dirPath => resolveWith =>
    new Promise((resolve, reject) => {
        fs.mkdir(dirPath, err => (err ? reject(err) : resolve(resolveWith)));
    });

export const mkdirIfNotExist = dirPath => resolveWith =>
    mkdirPromise(dirPath)(resolveWith).catch(err => {
        if (err.code === 'EEXIST') {
            return resolveWith;
        }
    });
