import qs from 'qs';

import GotOptions from '../../common/interfaces/server/GotOptions';

export default function getFullUriByGotOptions(options: GotOptions): string {
    const {protocol, hostname, path, query} = options;
    const queryString = query ? qs.stringify(query) : '';

    return `${protocol}//${hostname}${path}${
        queryString ? `?${queryString}` : ''
    }`;
}
