import fs from 'fs-extra';
import environment from '@yandex-int/yandex-environment';

import Environment from '../../common/interfaces/Environment';

import {
    IInformerBundlePath,
    getPathForInformerSvgSprite,
} from '../../webpack/staticUtils';

const cache: Record<string, string> = {};

function readFile({language}: IInformerBundlePath): string {
    return fs.readFileSync(getPathForInformerSvgSprite({language}), {
        encoding: 'utf8',
    });
}

export default function getInformerSvgSprite({
    language,
}: IInformerBundlePath): string {
    if (environment === Environment.development) {
        return readFile({language});
    }

    const key = `${language}`;

    if (!cache[key]) {
        cache[key] = readFile({language});
    }

    return cache[key];
}
