import environment from '@yandex-int/yandex-environment';
import {ComponentClass} from 'react';
import {Provider} from 'react-redux';
import {Moment} from '../../reexports/moment-timezone';
import {Loadable} from 'react-loadable';
import ReactDOMServer from 'react-dom/server';
import Helmet from 'react-helmet';

import Platform from '../../common/interfaces/Platform';
import Lang from '../../common/interfaces/Lang';
import Environment from '../../common/interfaces/Environment';

import StaticContext from '../../common/components/StaicContext/StaticContext';

import {getPathForNodeBundle, getBrowserPath} from '../../webpack/staticUtils';
import cartesianProduct from '../../common/lib/cartesianProduct';

const platforms = [Platform.mobile, Platform.desktop];
const languages = [Lang.ru, Lang.uk];
const modernBrowsers = [true, false];

const possibleParameters = cartesianProduct(
    platforms,
    languages,
    modernBrowsers,
);

interface IReactBundle {
    Root: ComponentClass<{throwError?: string}>;
    moment: Moment;
    Helmet: typeof Helmet;
    Loadable: Loadable;
    ReactDOMServer: typeof ReactDOMServer;
    Provider: typeof Provider;
    StaticContext: typeof StaticContext;
}

const bundles: Record<string, IReactBundle> = {};

possibleParameters.forEach(([platform, language, modernBrowser]) => {
    const bundlePath = getPathForNodeBundle({
        platform,
        language,
        modernBrowser,
    });

    try {
        bundles[bundlePath] = require(bundlePath);
    } catch (e) {
        if (environment !== Environment.development) {
            // eslint-disable-next-line
            console.error(
                `Bundle for "${getBrowserPath(
                    platform,
                    modernBrowser,
                )}-${language}" not found in ${bundlePath}`,
            );
        }
    }
});

export default function getReactBundle(
    platform: Platform,
    language: Lang,
    modernBrowser: boolean,
): IReactBundle {
    const bundlePath = getPathForNodeBundle({
        platform,
        language,
        modernBrowser,
    });

    if (environment === Environment.development) {
        delete require.cache[bundlePath];

        return require(bundlePath);
    }

    return bundles[bundlePath];
}
