import environment from '@yandex-int/yandex-environment';
import {FunctionComponent} from 'react';
import ReactDOMServer from 'react-dom/server';
import {Moment} from '../../reexports/moment-timezone';

import Lang from '../../common/interfaces/Lang';
import IRootInformers from '../../common/interfaces/components/IRootInformers';
import Environment from '../../common/interfaces/Environment';

import {getPathForNodeInformerBundle} from '../../webpack/staticUtils';
import cartesianProduct from '../../common/lib/cartesianProduct';

const languages = [Lang.ru, Lang.uk];

const possibleParameters = cartesianProduct(languages);

interface IReactInformerBundle {
    RootInformers: FunctionComponent<IRootInformers>;
    moment: Moment;
    ReactDOMServer: typeof ReactDOMServer;
}

const bundles: Record<string, IReactInformerBundle> = {};

possibleParameters.forEach(([language]) => {
    const bundlePath = getPathForNodeInformerBundle({language});

    try {
        bundles[bundlePath] = require(bundlePath);
    } catch (e) {
        if (environment !== Environment.development) {
            // eslint-disable-next-line
            console.error(
                `Informar bundle for "${language}" not found in ${bundlePath}`,
            );
        }
    }
});

export default function getReactInformerBundle(
    language: Lang,
): IReactInformerBundle {
    const bundlePath = getPathForNodeInformerBundle({language});

    if (environment === Environment.development) {
        delete require.cache[bundlePath];

        return require(bundlePath);
    }

    return bundles[bundlePath];
}
