import yaEnvironment from '@yandex-int/yandex-environment';
import yaConfig from '@yandex-int/yandex-config';

import {ASSESSORS_SUGGEST_URL} from '../../common/lib/suggests/constants';

import Environment from '../../common/interfaces/Environment';

const config = yaConfig();

export default function getSuggests(req) {
    const isProxyForAssessors =
        yaEnvironment !== Environment.production &&
        req.get('X-Assessors-Testing') === 'yes';

    const url = isProxyForAssessors
        ? `${process.env.ASSESSORS_SUGGEST_URL ?? ASSESSORS_SUGGEST_URL}/`
        : config.suggests.url;
    const credentials = url.includes(ASSESSORS_SUGGEST_URL)
        ? 'include'
        : 'same-origin';

    return {
        ...config.suggests,
        url,
        credentials,
    };
}
