import environment from '@yandex-int/yandex-environment';
import fs from 'fs';
import path from 'path';

import Environment from '../../common/interfaces/Environment';

let yandexInternalCA: Buffer | null = null;

export default function getYandexInternalCA(): Buffer {
    if (!yandexInternalCA) {
        yandexInternalCA =
            environment === Environment.development
                ? fs.readFileSync(
                      path.join(
                          __dirname,
                          '../../certs/YandexInternalRootCA.pem',
                      ),
                  )
                : fs.readFileSync('/etc/ssl/certs/YandexInternalRootCA.pem');
    }

    return yandexInternalCA;
}
