import {Span, Tags} from 'opentracing';

export default function addErrorInfoToTracerSpan(span: Span, err: any): void {
    span.setTag(Tags.ERROR, true);

    const logObject: Record<string, string | undefined> = {event: 'error'};

    if (err instanceof Error) {
        logObject.message = err.message;
        logObject.stack = err.stack?.slice(0, 1000);
    } else if (typeof err === 'string') {
        logObject.message = err;
    }

    span.log(logObject);
}
