import {initTracer, JaegerTracer} from 'jaeger-client';
import yaConfig from '@yandex-int/yandex-config';

const config = yaConfig();

let tracer: JaegerTracer | null = null;

export default function getTracer(): JaegerTracer {
    if (!tracer) {
        tracer = initTracer(
            {
                serviceName: config.jaeger.serviceName,
                sampler: {
                    type: 'probabilistic',
                    param: 0.001,
                },
            },
            {
                logger: {
                    // eslint-disable-next-line no-console
                    info: console.log,
                    // eslint-disable-next-line no-console
                    error: console.error,
                },
            },
        );
    }

    return tracer;
}
