import path from 'path';
import fsExtra from 'fs-extra';
import moment from 'moment';
import heapdump from 'heapdump';

import getFormattedHeapSpaceStatistics from './getFormattedHeapSpaceStatistics';

// Создает файл со статистикой использования памяти и снэпшот кучи
// Файлы будут располагаться в директории /reports/memory/<pid>/2020-09-08_09-39-00/
export default async function recordMemoryInfo(): Promise<void> {
    const nowString = moment().format('YYYY-MM-DD_HH-mm-ss');
    const pid = String(process.pid);
    const dirForReport = path.join(
        __dirname,
        '../../../reports/memory/',
        pid,
        nowString,
    );

    await fsExtra.ensureDir(dirForReport);

    const pathForHeapSpaceStatistic = path.join(
        dirForReport,
        `heapSpace-${pid}-${nowString}.json`,
    );
    const pathForHeapSnapshot = path.join(
        dirForReport,
        `dump-${pid}-${nowString}.heapsnapshot`,
    );

    if (global.gc) {
        global.gc();
    }

    const formattedHeapSpaceStatistic = getFormattedHeapSpaceStatistics();

    await fsExtra.writeFile(
        pathForHeapSpaceStatistic,
        JSON.stringify(formattedHeapSpaceStatistic, undefined, 2),
    );

    await writeSnapshot(pathForHeapSnapshot);

    if (global.gc) {
        global.gc();
    }
}

function writeSnapshot(pathToFile: string): Promise<void> {
    return new Promise((resolve, reject) => {
        heapdump.writeSnapshot(pathToFile, err => {
            if (err) {
                return reject(err);
            }

            resolve();
        });
    });
}
