import {createCookiesIfNotExists, deleteCookie, setCookie} from '../cookies';

/**
 * Класс для эмуляции объекта res из express
 * Можно применять, к примеру, для тестирования middleware
 */
export default class Res {
    constructor() {
        this.query = {};

        createCookiesIfNotExists({res: this});
    }

    cookie(name, value, options = {}) {
        setCookie(this, name, value, options);
    }

    clearCookie(name) {
        deleteCookie(this, name);
    }
}
