function getRandomInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

const defaultOptions = {
    maxAge: 10 * 365 * 24 * 60 * 60 * 1000,
};

/**
 * Устанавливает куку для эксперимента
 * @param {Object} cookies - объект cookies с методами get / set
 * @param {string} name - имя куки
 * @param {string} value - значение для экспериментальной куки
 * @param {string} otherValue - значение для куки если человек не попал в эксперимент
 * @param {number} amount - процент людей которые должны попасть в выборку
 * @param {Object} [options=defaultOptions] - дополнительные опции для сеттера куки
 * @return {string|null}
 */
export default function setExperimentCookie({
    cookies,
    name,
    value,
    otherValue,
    amount,
    options = defaultOptions,
}) {
    const randomNumber = getRandomInt(1, 100);

    if (randomNumber <= amount) {
        cookies.set(name, value, options);

        return value;
    }

    cookies.set(name, otherValue, options);

    return otherValue;
}
