import {Response} from 'got';
import yaConfig from '@yandex-int/yandex-config';

import HttpMethod from '../../../common/interfaces/HttpMethod';

import timedGot from '../timedGot';

const startrekConfig = yaConfig().startrek;

interface IApiRequest {
    path: string; // Метод API. Например: /v2/issues/STARTREK-1/comments
    body: Record<string, any>;

    oauthKey?: string; // По умолчанию будет использован ключ robot-rasp
}

export default function apiRequest({
    path,
    body,

    oauthKey = startrekConfig.key,
}: IApiRequest): Promise<Response<string>> {
    return timedGot({
        ...startrekConfig.options,
        method: HttpMethod.post,
        path,
        json: true,
        body,
        headers: {
            Authorization: `OAuth ${oauthKey}`,
        },
    });
}
