'use strict';

module.exports = {
    isRouteNumber(text) {
        text = this.normalizeRouteNumber(text);

        if (/^\d+$/.exec(text)) {
            return true;
        }

        if (this.isKilometerStation(text)) {
            return false;
        }

        return this.isPlaneRouteNumber(text) || this.isRailwayRouteNumber(text);
    },

    normalizeRouteNumber(text) {
        return text
            .toLowerCase()
            .replace('автобус', '')
            .replace('вагон', '')
            .replace('поезд', '')
            .replace('№', '')
            .replace(/\s/g, '')
            .replace('-', '');
    },

    isKilometerStation(text) {
        return Boolean(/^\d+(км|km)$/.exec(text));
    },

    isPlaneRouteNumber(text) {
        return (
            Boolean(/^[a-zа-яё]{2}\d{1,6}$/.exec(text)) ||
            Boolean(/^\d[a-zа-яё]\d{1,6}$/.exec(text)) ||
            Boolean(/^[a-zа-яё]\d\d{1,6}$/.exec(text))
        );
    },

    isRailwayRouteNumber(text) {
        return Boolean(/^\d+[a-zа-яё]{1,2}$/.exec(text));
    },
};
