import {Response} from 'got';
import yaConfig from '@yandex-int/yandex-config';

import HttpMethod from '../../../common/interfaces/HttpMethod';

import timedGot from '../timedGot';

const ypConfig = yaConfig().yp;

interface IApiRequest {
    path: string;

    body?: Record<string, any>;
    retries?: number;
    headers?: Record<string, string>;
}

export default function apiRequest({
    path,
    body,
    retries = 0,
}: IApiRequest): Promise<Response<any>> {
    return timedGot({
        ...ypConfig.options,
        retries,
        method: HttpMethod.post,
        path,
        json: true,
        body,
        headers: {
            Authorization: `OAuth ${ypConfig.token}`,
        },
    });
}
