import apiRequest from './apiRequest';

interface IDeployUnitStatus {
    status: 'false' | 'true';
    last_transition_time: {
        nanos: number;
        seconds: number;
    };
}

interface IDeployUnitStatuses {
    failed: IDeployUnitStatus;
    in_progress: IDeployUnitStatus;
    ready: IDeployUnitStatus;
}

interface IStageStatus {
    deploy_units: Record<string, IDeployUnitStatuses>;
}

export async function getStageStatus(
    stage: string,
): Promise<IStageStatus | null> {
    const {
        body: {
            result: {
                values: [data],
            },
        },
    } = await apiRequest({
        path: '/ObjectService/GetObject',
        body: {
            object_type: 'stage',
            object_id: stage,
            selector: {
                paths: ['/status'],
            },
        },
    });

    return data;
}
