/* eslint no-console: 0 */
import npmlog from 'npmlog';
import yaConfig from '@yandex-int/yandex-config';
import {momentTimezone as moment} from '../reexports';
import formatDeployLogMessage from './helpers/deploy/formatDeployLogMessage';
import {EDeployLevel} from './helpers/deploy/types';
import prepareDeployLoggerLevel from './helpers/deploy/prepareDeployLoggerLevel';

const config = yaConfig();
const prefix = path => `[${moment().format()}] ${path}`;

const logger = {
    info(path, message) {
        const msg = `${prefix(path)} ${message}`;

        if (config.useQloudLogging) {
            console.log(
                JSON.stringify({
                    message: msg,
                    level: 'info',
                }),
            );
        } else if (config.useDeployLogging) {
            console.log(
                JSON.stringify(
                    formatDeployLogMessage({
                        message: msg,
                        levelStr: EDeployLevel.INFO,
                    }),
                ),
            );
        } else {
            npmlog.info(prefix(path), message);
        }
    },

    http(path, message) {
        if (config.useQloudLogging || config.useDeployLogging) {
            this.info(path, message);
        } else {
            npmlog.http(prefix(path), message);
        }
    },

    error(
        path,
        err,
        {stackTrace = null, message = '', tags = {}, level = 'warning'} = {},
    ) {
        if (typeof err === 'string') {
            err = new Error(err);
        }

        const stack = stackTrace || err.stack;
        const msg = `${prefix(path)} ${message ? `${message}: ` : ''}${
            err.message
        }`;

        if (config.useQloudLogging) {
            console.log(
                JSON.stringify({
                    message: msg,
                    stackTrace: stack,
                    level,
                    tags,
                }),
            );
        } else if (config.useDeployLogging) {
            console.log(
                JSON.stringify(
                    formatDeployLogMessage({
                        message: msg,
                        stackTrace: stack,
                        levelStr: prepareDeployLoggerLevel(level),
                        tags,
                    }),
                ),
            );
        } else {
            npmlog.error(prefix(path), message, err);
        }
    },
};

export default logger;
