import storeTld from './middleware/storeTld';
import storeLanguage from './middleware/storeLanguage';
import storeNationalVersion from './middleware/storeNationalVersion';
import storeSelectedCurrency from './middleware/storeSelectedCurrency';
import storeSuggestsConfig from './middleware/storeSuggestsConfig';
import settlementParams from './middleware/settlementParams';
import settlement from './middleware/settlement';
import storeClientSettlement from './middleware/storeSettlement';
import storeSearchCalendarVisibility from './middleware/storeSearchCalendarVisibility';
import storeUser from './middleware/storeUser';
import headerView from './middleware/headerView';
import environment from './middleware/environment';
import platform from './middleware/platform';
import storeFlags from './middleware/storeFlags';
import storeIsTouch from './middleware/storeIsTouch';
import storeGeneratedInputName from './middleware/storeGeneratedInputName';
import storeSeoQueryParams from './middleware/storeSeoQueryParams';

export default function middleware(adapter) {
    adapter.use('*', storeTld);
    adapter.use('*', storeLanguage);
    adapter.use('*', storeNationalVersion);
    adapter.use('*', storeSelectedCurrency);
    adapter.use('*', storeSuggestsConfig);
    adapter.use('*', storeFlags);
    adapter.use('*', storeIsTouch);
    adapter.use('*', storeGeneratedInputName);
    adapter.originalApp.use('*', settlementParams);
    adapter.originalApp.use('*', settlement);
    adapter.use('*', storeClientSettlement);
    adapter.use('*', storeSearchCalendarVisibility);
    adapter.use('*', storeUser);
    adapter.use('*', headerView);
    adapter.use('*', environment);
    adapter.use('*', platform);
    adapter.use('*', storeSeoQueryParams);
}
