/* eslint-disable require-atomic-updates */
import {ABTSplitter} from '@yandex-int/abt';
import {Request, Response, NextFunction} from 'express';

import IExpressRequest from '../../common/interfaces/IExpressRequest';

const abt = new ABTSplitter({service: 'travel', handler: 'RASP'});

export default async function abtExperiments(
    req: Request & Pick<IExpressRequest, 'flags' | 'abtInfo'>,
    res: Response,
    next: NextFunction,
): Promise<void> {
    try {
        const info = await abt.askForInfo(req.headers, undefined, {
            timeout: 500,
        });

        req.abtInfo = info;

        req.flags = {
            ...req.flags,
            ...info.flags,
        };
    } finally {
        next();
    }
}
