import url from 'url';
import {Request, Response, NextFunction} from 'express';

import AlternateLanguageDomains from '../../common/interfaces/lib/url/AlternateLanguageDomains';
import IExpressRequest from '../../common/interfaces/IExpressRequest';

import {getObjectWithoutProps} from '../../common/lib/objectUtils';

export default function (altLangDomains: AlternateLanguageDomains[]) {
    return function (
        req: Request & Pick<IExpressRequest, 'altLinks'>,
        res: Response,
        next: NextFunction,
    ): void {
        req.altLinks = altLangDomains.map(domain => ({
            rel: 'alternate',
            href: url.format({
                protocol: req.protocol,
                host: domain.host,
                pathname: req.path,
                query: Object.assign(
                    getObjectWithoutProps(req.query, ['lang']),
                    domain.query,
                ),
            }),
            hreflang: domain.hreflang,
        }));

        next();
    };
}
