import {Request, Response, NextFunction} from 'express';

import IExpressRequest from '../../common/interfaces/IExpressRequest';

const needles = [
    'YandexBot/',
    'YandexImages/',
    'YandexMedia/',
    'YandexVideo/',
    'YandexFavicons/',
    'YandexDirect/',
    'YandexCatalog/',
    'YandexMedia/',
    'Yandex/',
    'YandexWebmaster/',
    'YandexSomething/',
    'YandexMobileBot/',
    'YandexRCA/',
    'YandexDirectDyn/',
    'YandexBlogs/',
    'YandexPagechecker/',
    'YandexImageResizer/',
    'YandexAdNet/',
    'YaDirectFetcher/',
    'YandexCalendar/',
    'YandexSitelinks',
    'YandexMetrika/',
    'YandexNews/',
    'YandexNewslinks',
    'YandexAntivirus/',
    'YandexMarket/',
    'YandexVertis/',
    'YandexForDomain/',
    'Googlebot-',
    'Googlebot/',
    'msnbot-',
    'MSNBot/',
    'Yahoo! Slurp;',
    'Yahoo! Slurp/',
    'Mail.RU_Bot/',
    'Mail.RU/',
    'Mail.Ru/',
    'facebookexternalhit', // https://developers.facebook.com/docs/sharing/webmasters/crawler
    'Twitterbot', // https://dev.twitter.com/cards/getting-started
    'vkShare', // http://user-agents.me/crawler/mozilla50-compatible-vkshare-httpvkcomdevshare

    // seems that it's safe to use just "Google"
    // http://www.useragentstring.com/pages/Browserlist/
    'Google', // http://stackoverflow.com/questions/20750191/google-plus-crawler

    'OdklBot', // http://myip.ms/view/comp_browseragents/552447/OdklBot_1_0_klassodnoklassniki_ru.html

    'Slackbot-LinkExpanding', // https://api.slack.com/robots

    'LinkedInBot',
    'TelegramBot',
    'Applebot', // https://support.apple.com/en-in/HT204683
    'tumblr ',
];
// eslint-disable-next-line
const botRe = new RegExp(`(${needles.join(')|(').replace(/\//g, '\\/')})`, 'i');

function isSearchEngineBot(req: Request): boolean {
    return botRe.test(req.headers['user-agent'] || '');
}

export default function (
    req: Request &
        Pick<IExpressRequest, 'isBot' | 'isSearchBot' | 'hasYandexUid'>,
    res: Response,
    next: NextFunction,
): void {
    req.isBot = false;
    req.isSearchBot = isSearchEngineBot(req);

    if (req.isSearchBot) {
        req.isBot = true;
        next();

        return;
    }

    if (!req.hasYandexUid) {
        req.isBot = true;
        next();

        return;
    }

    next();
}
