import {NextFunction} from 'express';

import IExpressRequest from '../../common/interfaces/IExpressRequest';
import IExpressResponse from '../../common/interfaces/IExpressResponse';

import addErrorInfoToTracerSpan from '../helpers/jaeger/addErrorInfoToTracerSpan';

export default function errorRegisterForRootSpan(
    err: any,
    req: IExpressRequest,
    res: IExpressResponse,
    next: NextFunction,
): void {
    const {rootSpan} = req;

    if (!rootSpan) {
        return next(err);
    }

    addErrorInfoToTracerSpan(rootSpan, err);

    next(err);
}
