import yaConfig from '@yandex-int/yandex-config';
import cookies from '../helpers/cookies';
import {
    meetExperimentDependencies,
    getOrSetExperimentCookie,
    completeExperimentData,
    parseRawValue,
    sortExperimentKeysByDeps,
} from '../helpers/experiments';

const config = yaConfig();

module.exports = function (req, res, next) {
    const flags = {};
    const experimentsKeys = Object.keys(config.experiments);
    const getExperimentsValues = Object.values(config.experiments).map(
        experiment =>
            typeof experiment === 'function' ? experiment(req) : experiment,
    );

    return Promise.all(getExperimentsValues)
        .then(experimentsValues => {
            const experiments = {};

            experimentsKeys.forEach((key, index) => {
                if (experimentsValues[index]) {
                    experiments[key] = completeExperimentData(
                        experimentsValues[index],
                    );
                }
            });

            const keys = sortExperimentKeysByDeps(experiments);

            keys.forEach(key => {
                const experiment = experiments[key];
                const {denied, defaultValue, dependencies} = experiment;
                const rawValue = req.query && req.query[key];

                if (rawValue) {
                    // Перекрываем значениями из query
                    flags[key] = parseRawValue(rawValue, experiment);

                    return null;
                }

                if (
                    !dependencies ||
                    meetExperimentDependencies(dependencies, flags)
                ) {
                    // выполнены условия родительских экспериментов
                    if (denied) {
                        // если эксперимент запрещен, то выставляем дефолтное значение
                        flags[key] = defaultValue;
                    } else {
                        // Считаем значения экспериментов в соответствии с конфигом
                        flags[key] = getOrSetExperimentCookie(
                            key,
                            experiment,
                            cookies(req, res),
                        );
                    }
                }
            });

            req.flags = {
                ...req.flags,
                ...flags,
            };
            next();
        })
        .catch(() => {
            req.flags = {
                ...req.flags,
                ...flags,
            };
            next();
        });
};
