import {Request, Response, NextFunction} from 'express';

import IExpressRequest from '../../common/interfaces/IExpressRequest';

export default function (
    req: Request & Pick<IExpressRequest, 'fullUrl'>,
    res: Response,
    next: NextFunction,
): void {
    req.fullUrl = `${req.protocol}://${req.get('host')}${req.originalUrl}`;
    next();
}
