import {v4 as uuid} from 'uuid';
import {Response, Request, NextFunction} from 'express';

import IExpressRequest from '../../common/interfaces/IExpressRequest';

export default function (
    req: Request & Pick<IExpressRequest, 'requestId'>,
    res: Response,
    next: NextFunction,
): void {
    req.requestId = req.get('X-Request-Id') || uuid();
    res.set('X-Request-Id', req.requestId);
    next();
}
