module.exports = function (config, USE_HTTP_SERVICES) {
    let cb;

    if (USE_HTTP_SERVICES) {
        cb = require('@yandex-int/express-national-redirect2');
    } else {
        cb = require('@yandex-int/express-national-redirect').default;
    }

    return (req, res, next) => {
        const nationalRedirects = req.isTouchDomain
            ? config.nationalredirectTouch
            : config.nationalredirect;

        cb(nationalRedirects)(req, res, next);
    };
};
