// Некоторые яндексовые библиотеки используют данный заголовок для формирования урлов.
// Но наша схема работы с prestable предполагает проксирование запроса через балансер,
// который добавляет свой заголовок "x-original-url" со значением урл от prestable,
// из-за чего, в некоторых ситуациях, происходят редиректы пользователей на prestable
export default function patchHeaderXOriginUrl(req, res, next) {
    req.headers[
        'x-original-url'
    ] = `${req.protocol}://${req.hostname}${req.originalUrl}`;
    next();
}
