import url from 'url';

import getNationalLanguage from '../../common/lib/lang/getNationalLanguage';
import getAvailableLanguages from '../../common/lib/lang/getAvailableLanguages';

module.exports = function processLanguage(req, res, next) {
    let lang = '';
    const availableLanguages = getAvailableLanguages(req.tld);
    const nationalLanguage = getNationalLanguage(req.tld);
    const isAvailable = checkLang =>
        availableLanguages.indexOf(checkLang) !== -1;

    if (req.query.lang && isAvailable(req.query.lang)) {
        lang = req.query.lang;
    } else if (req.isBot) {
        lang = nationalLanguage;
    } else {
        lang = req.langdetect.id;

        if (lang !== nationalLanguage) {
            const redirectPath = url.format({
                protocol: req.protocol,
                host: req.get('host'),
                pathname: req.path,
                query: {
                    ...req.query,
                    lang,
                },
            });

            res.redirect(302, redirectPath);

            return;
        }
    }

    req.language = lang;
    next();
};
