import url from 'url';

import keyset from '../../common/i18n/calendar';

const paramsIndexes = {
    fromName: 1,
    toName: 2,
    fromId: 3,
    toId: 4,
    when: 5,
};

function isEmpty(param) {
    return !param || String(param).trim() === '';
}

/**
 * Редирект when="на все дни" для запросов с пустым when
 * @param {Object} req - объект запроса
 * @param {Object} res - объект ответа
 * @param {Function} next - callback для продолжения
 */
module.exports = function redirectSearchWhen(req, res, next) {
    if (!req.searchNext && isEmpty(req.query.when)) {
        const queryParams = {
            ...req.query,
            when: keyset('all-days'),
        };

        // Сортируем параметры в правильном порядке
        const query = Object.keys(queryParams)
            .sort(
                (a, b) => (paramsIndexes[a] || 999) - (paramsIndexes[b] || 999),
            )
            .reduce((acc, param) => {
                acc[param] = queryParams[param];

                return acc;
            }, {});

        const redirectPath = url.format({
            protocol: req.protocol,
            host: req.get('host'),
            pathname: url.parse(req.originalUrl).pathname, // /search, /search/train, etc.
            query,
        });

        res.redirect(301, redirectPath);

        return;
    }

    next();
};
