import api from '../api';
import logger from '../logger';

export default (req, res, next) => {
    api.exec('settlement', req.settlementParams, req)
        .then(settlement => {
            req.settlement = settlement;
        })
        .catch(err => {
            logger.error('server/middleware/settlement', err);
        })
        .then(() => {
            if (!req.settlement) {
                req.settlement = require('../fixtures/settlement');
            }

            next();
        });
};
