import logger from '../logger';
import * as geobaseHelper from '../helpers/geobaseHelper';

export default (req, res, next) => {
    const nationalVersion = req.tld.split('.').pop();

    req.settlementParams = {
        ...req.settlementParams,
        nationalVersion,
        language: req.langdetect.id,
    };

    if (req.isBot) {
        return next();
    }

    geobaseHelper
        .getRegionByRequest(req)
        .then(tuneRegion => {
            req.tuneRegion = tuneRegion;

            return geobaseHelper.getCityHierarchy(tuneRegion.id);
        })
        .then(geoIds => {
            if (geoIds.length) {
                req.settlementParams.geoIds = geoIds;
            }
        })
        .catch(e => logger.error('server/middleware/settlementParams', e))
        .then(() => next());
};
