import {setPreferredCurrency} from '../../common/actions/currencies';

const currencyCodes = require('../../common/interfaces/CurrencyCode');

function isAvailable(currency) {
    return currency && currencyCodes[currency];
}

export default function storeSelectedCurrency({store, req, next}) {
    if (isAvailable(req.query.currency)) {
        store.dispatch(setPreferredCurrency(req.query.currency));
    } else if (isAvailable(req.cookies.preferredcurrency)) {
        store.dispatch(setPreferredCurrency(req.cookies.preferredcurrency));
    }

    next();
}
